'File BitOrderReverse.bas written 08-09-2020 17:43:30
'a CSUB to reverse the order of bits for CMM2
'Usage:
'CSUB BitOrderReverse(nInput, nBits, RetValue)


dim integer a, b, nBits
'   123456789012345678901234567890123456789012345678901234567890
'            1         2         3         4         5         6
a=&b0010111100101111001011110010111100101111001011110010111100101111

? "BitOrderReverse Demo":?

b=0
nBits=64
l=10000 'loops

? "Input:"
? bin$(a,nBits)

'b=bore(a,nBits)
'BitOrderReverse(a,nBits,b)

timer=0
for i = 1 to l
BitOrderReverse(a,nBits,b)
next i
t0=timer

timer=0
for i = 1 to l
b=bore(a,nBits)
next i
t1=timer


timer=0
for i = 1 to l
next i
t2=timer

? "Output:"
? bin$(b,nBits)


? l " loops:",,"CSUB",,"FUNC",,,"Empty",,"1x CSUB","1x FUNC"
? ,,,,,,,cint(t0)"ms",cint(t1)"ms",,cint(t2)"ms",,,cint((t0-t2)/l*1000)"us",,cint((t1-t2)/l*1000)"us"

end


'BitOrderReverse as function using CSUB BitOrderReverse, needs 56us @400Mhz
function bore(UL as integer,BL as integer) as integer
  local integer ret
  BitOrderReverse(UL,bl,ret)
  bore=ret
end function


'File Bitorderreverse.bas written 04-10-2020 00:23:22
'a CSUB to reverse the order of bits for CMM2, needs 11us @400Mhz
'Compiler opt -o3
'Usage:
'CSUB BitOrderReverse(nInput, nBits, RetValue)
CSUB BitOrderReverse' integer, integer integer
  00000000
  'Bitorderreverse
  C000F8D1 4FF0E92D 0F00F1BC 9203B085 1200E9D0 F10CDD3A 46963AFF 91022300 
  21014652 461F46F2 93014696 0620F1A3 0020F1C3 0203EBAE FB03FA01 F606FA01 
  F000FA21 0420F1A2 0520F1C2 9E024330 F404FA01 F505FA21 0806EA0B 090AEA00 
  F202FA01 EA583301 EA440009 D0040405 9A0119D7 0202EB44 459C9201 9B03D1D6 
  601F9A01 B005605A 8FF0E8BD 97012700 BF00E7F5 
End CSUB

'File BitOrderReverse.bas written 08-09-2020 17:43:30
'a CSUB to reverse the order of bits for CMM2, needs 22us @400Mhz
'Compiler opt -o0
'Usage:
'CSUB BitOrderReverse(nInput, nBits, RetValue)
CSUB BitOrderReverse1 integer, integer integer
  00000000
  'borev
  0FF0E92D AF00B08C 61B961F8 2301617A 697962FB 0200F04F 0300F04F 2300E9C1 
  0201F04F 0300F04F 2308E9C7 69FBE04A 2300E9D3 469B4692 1E586AFB 2308E9D7 
  0620F1A0 0120F1C0 F500FA03 F606FA02 FA224335 430DF101 F400FA02 0304EA0A 
  EA0B60BB 60FB0305 2302E9D7 D0264313 E9D3697B 46922300 69BB469B 2300E9D3 
  1AD06AFB 2308E9D7 0620F1A0 0120F1C0 F900FA03 F606FA02 0906EA49 F101FA22 
  0901EA49 F800FA02 0308EB1A EB4B603B 607B0309 2300E9D7 E9C16979 6AFB2300 
  62FB3301 461A6AFB 73E2EA4F E9D169B9 42900100 0303EB71 BF00DAA9 3730BF00 
  E8BD46BD 47700FF0 
End CSUB

                                                                       